<?php
/**
 * Module Name: Invite Anyone Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'invite_anyone_init' ) ) :

 //*************** Actions ***************\\
 add_action('sent_email_invite', 'wpachievements_invite_sent', 10, 3);
 add_action('accepted_email_invite', 'wpachievements_invite_accepted', 10, 2);
 //*************** Detect adding of favorite ***************\\
 function wpachievements_invite_sent($user_id, $email, $group){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'sentinvite',
    'user_id'     => $user_id,
    'post_id'     => '',
    'points'      => 0,
  ) );      
 }
 //*************** Detect removal of favorite ***************\\
 function wpachievements_invite_accepted($invited_user_id, $inviters){
   if( is_array($inviters) ){
     foreach($inviters as $inviter_id){
       WPAchievements_Trigger::new_activity( array(
        'activity'    => 'inviteacceptance',
        'user_id'     => $inviter_id,
        'post_id'     => '',
        'points'      => (int) wpachievements_get_site_option('wpachievements_iv_invite_acceptance_points'),
      ) );   
     }
   } else{
     WPAchievements_Trigger::new_activity( array(
      'activity'    => 'inviteacceptance',
      'user_id'     => $inviters,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_iv_invite_acceptance_points'),
    ) );       
   }
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_ia_desc', 10, 4);
 function achievement_ia_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'sentinvite': { $text = sprintf( _n( 'for sending %s invite', 'for sending %s invites', $times, 'wpachievements'), $times ); } break;
   case 'inviteacceptance': { $text = sprintf( _n( 'for %s invite being accepted', 'for %s invites being accepted', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_ia_desc', 10, 3);
 function quest_ia_desc($text='',$type='',$times=''){
  switch($type){
   case 'sentinvite': { $text = sprintf( _n( 'Send %s invite', 'Send %s invites', $times, 'wpachievements'), $times ); } break;
   case 'inviteacceptance': { $text = sprintf( _n( 'Have %s invite accepted', 'Have %s invites accepted', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_ia' );
function wpachievements_add_section_ia( $sections ) {
	$sections['ia'] = __( 'Invite Anyone', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_ia_admin', 10, 3);
function wpachievements_ia_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'ia' ) {
    $settings[] = array( 'title' => __( 'Invite Anyone', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'InviteAnyone_options' );

    $settings[] = array(
            'title'   => __( 'User Invite Accepted', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the users invite is accepted.', 'wpachievements' ),
            'id'      => $shortname.'_iv_invite_acceptance_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'InviteAnyone_options');

    return $settings;
  /**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_ia_admin_events', 10);
 function achievement_ia_admin_events(){
   echo'<optgroup label="Invite Anyone Events">
     <option value="sentinvite">'.__('The user invites someone', 'wpachievements').'</option>
     <option value="inviteacceptance">'.__('The users invitation is accepted', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_ia_admin_triggers', 1, 10);
 function achievement_ia_admin_triggers($trigger){

   switch($trigger){
     case 'sentinvite': { $trigger = __('The user invites someone', 'wpachievements'); } break;
     case 'inviteacceptance': { $trigger = __('The users invitation is accepted', 'wpachievements'); } break;
   }

   return $trigger;

 }
endif;
?>